// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.
//https://www.shadertoy.com/view/Xlc3D2

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300

#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else

varying vec2 uv;

#endif

varying highp vec3 pos;

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"
#include "util.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;

void main()
{
#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
	vec4 diffuse = texture2D( TEXTURE_0, uv );
#else
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv );
#endif

#ifdef ALPHA_TEST
	if(diffuse.a < 0.5)
		discard;
#endif

vec4 fc = FOG_COLOR;

float day_f = pow(max(min(1.0-fc.b * 1.2, 1.0), 0.0), 0.5);
float night_f = pow(max(min(1.0-fc.r * 1.5, 1.0), 0.0), 1.2);
float rain_f = (1.0 - pow(FOG_CONTROL.y, 11.0));

float a = atan(pos.x, pos.y);
//float l = max(1.0 - length(pos.xz) - 0.85, 0.0);
float l = 0.01;

vec3 sun_moon = mix(mix(mix(vec3(1.1,0.95,0.89),fc.rgb,day_f)*1.9,vec3(1.0,1.0,1.0),night_f),fc.rgb,rain_f);

sun_moon += max(0.1 / pow(length(pos.xz*1.4*smoothstep(1.5, 0.0, night_f)) * 3.0, 5.0), 0.0) * abs(sin(a * 5.0 + cos(a * 9.0))) / 90.0;

sun_moon += max(0.1 / pow(length(pos.xz*1.4*smoothstep(1.5, 0.0,night_f)) * 1.0, 1.0 / 10.0), .0) + abs(sin(a * 3.0 + cos(a * 9.0))) / 8.0 * (abs(sin(a * 10.0))) / 1.0;

sun_moon += (max(l / pow(length(pos.xz*1.4*smoothstep(1.5, 0.0,night_f)) * 4.0, 1.0 / 2.0), 0.0) * 4.0) * 1.5;

sun_moon *= exp(0.4 - length(pos.xz)) / 7.5;

/*
vec2 moonp = vec2(0.5,0.8);
float moon = smoothstep(0.91,0.956,1.-length(pos.xz*0.3-moonp));
vec2 moonp2 = moonp + vec2(0.03, 0);
moon -= smoothstep(0.935,0.960,1.-length(pos.xz*0.3-moonp2));
moon = clamp(moon, 0., 1.0);
moon += 0.2*smoothstep(0.80,0.956,1.-length(pos.xz*0.3-moonp));
vec3 moonc = vec3(1.1,1.0,1.0);
*/

gl_FragColor.rgb = sun_moon;
//gl_FragColor.rgb = mix(gl_FragColor.rgb,moonc,moon);
gl_FragColor.a = 1.0*smoothstep(0.5, 0.0, rain_f);



}
